' DISPLAY.BAS

Option Explicit
Dim ScreenBuffer(0 To 23) As String * 80
Dim CurrentRow As Integer
Dim CurrentCol As Integer

Sub DisplayChar (F As Form, ByVal C As Integer)
  Dim Row As Integer
  Dim Col As Integer
  C = &H7F And C
  'process char
  If C = 13 Then
    'carriage control
    CurrentCol = 0
    'plus assumed line feed
    If CurrentRow < 23 Then
      CurrentRow = CurrentRow + 1
      'print CR+LF
      F.Print " "
    Else
      'scroll !
      F.Cls
      For Row = 0 To 22
        'print row
        ScreenBuffer(Row) = ScreenBuffer(Row + 1)
        F.Print ScreenBuffer(Row)
      Next Row
      'clear bottom row
      ScreenBuffer(23) = Space$(80)
    End If
  ElseIf C = 10 Then
    'throw away line feeds
  Else
    'not CR or LF
    CurrentCol = CurrentCol + 1
    If CurrentCol > 79 Then
      'throw away !
      Exit Sub
    Else
      'save in screen buffer & display
      Mid$(ScreenBuffer(CurrentRow), CurrentCol, 1) = Chr$(C)
      F.Print Chr$(C);
    End If
  End If
'display caret
Col = F.CurrentX
F.Print "_";
F.CurrentX = Col
End Sub

Sub DisplayInit (F As Form)
Dim Row As Integer
CurrentCol = 0
CurrentRow = 0
For Row = 0 To 23
  ScreenBuffer(Row) = Space$(80)
Next Row
F.FontTransparent = False
F.Cls
End Sub

Sub DisplayLine (F As Form, Text As String)
  Call DisplayString(F, Text)
  Call DisplayChar(F, 13)
End Sub

Sub DisplayString (F As Form, Text As String)
  Dim i As Integer
  Dim Length As Integer
  Length = Len(Text)
  For i = 1 To Length
    Call DisplayChar(F, Asc(Mid$(Text, i, 1)))
  Next i
End Sub

